/*
 * Decompiled with CFR 0.152.
 */
package com.mcsync.plugin;

import com.mcsync.plugin.Auth;
import com.mcsync.plugin.PermissionAssigner;
import com.mcsync.plugin.mcsync;
import com.mcsync.plugin.org.json.JSONException;
import com.mcsync.plugin.org.json.JSONObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class AsyncLoginGate
implements Listener {
    private final Set<UUID> toKick = Collections.synchronizedSet(new HashSet());
    private final mcsync plugin;
    private final LuckPerms luckPerms;
    private final boolean luckPermsEnabled;
    private final PermissionAssigner permissionAssigner;

    public AsyncLoginGate(mcsync plugin) {
        this.plugin = plugin;
        Plugin lpPlugin = Bukkit.getPluginManager().getPlugin("LuckPerms");
        this.luckPermsEnabled = lpPlugin != null && lpPlugin.isEnabled();
        this.luckPerms = this.luckPermsEnabled ? LuckPermsProvider.get() : null;
        this.permissionAssigner = this.luckPermsEnabled ? new PermissionAssigner(this.luckPerms, plugin.getConfig()) : null;
    }

    private FileConfiguration getConfig() {
        return this.plugin.getConfig();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        int tier;
        boolean authorizePlayer;
        String failMessage;
        String parameters;
        String playerName;
        UUID uuid;
        block19: {
            uuid = event.getUniqueId();
            playerName = event.getName();
            String token = this.getConfig().getString("token");
            String parametersRaw = this.getConfig().getString("parameters", "");
            parameters = parametersRaw == null ? "" : parametersRaw.toLowerCase();
            String failMessageRaw = this.getConfig().getString("fail_message", "You are not authorized to join this server.");
            failMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)(failMessageRaw == null ? "You are not authorized to join this server." : failMessageRaw));
            if (parameters.contains("debug")) {
                Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] PreLogin called for %s UUID: %s", playerName, uuid));
            }
            boolean isWhitelisted = this.getServer().getWhitelistedPlayers().stream().anyMatch(whitelistedPlayer -> whitelistedPlayer.getUniqueId().equals(uuid));
            authorizePlayer = false;
            tier = 0;
            if (parameters.contains("debug")) {
                Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Async thread started for %s UUID: %s", playerName, uuid));
            }
            if (isWhitelisted) {
                authorizePlayer = true;
                tier = 0;
                if (parameters.contains("debug")) {
                    Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] User is Whitelisted: %s", playerName));
                }
            } else {
                try {
                    if (parameters.contains("debug")) {
                        Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Calling Auth.check for %s UUID: %s", playerName, uuid));
                    }
                    String authResult = Auth.check(token, uuid.toString().replace("-", ""), parameters);
                    if (parameters.contains("debug")) {
                        Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Auth.check result for %s: %s", playerName, authResult));
                    }
                    JSONObject resultObj = new JSONObject(authResult);
                    authorizePlayer = resultObj.optBoolean("authorize", false);
                    tier = resultObj.optInt("tier", 0);
                    if (parameters.contains("debug")) {
                        Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Authorize: %s finalTier: %d", authorizePlayer, tier));
                    }
                }
                catch (JSONException | NullPointerException e) {
                    if (parameters.contains("debug")) {
                        Bukkit.getLogger().warning(String.format("[AsyncLoginGate][DEBUG] Failed to parse auth result: %s", e.getMessage()));
                    }
                }
                catch (Exception e) {
                    if (!parameters.contains("debug")) break block19;
                    Bukkit.getLogger().warning(String.format("[AsyncLoginGate][DEBUG] Unexpected error: %s", e.getMessage()));
                }
            }
        }
        if (!authorizePlayer) {
            if (parameters.contains("debug")) {
                Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Kicking %s UUID: %s (pre-login)", playerName, uuid));
            }
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, failMessage);
            this.toKick.add(uuid);
            if (parameters.contains("debug")) {
                Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Added %s to toKick set", uuid));
            }
        } else {
            boolean removed = this.toKick.remove(uuid);
            if (removed && parameters.contains("debug")) {
                Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Removed %s from toKick set after successful auth", uuid));
            }
            if (parameters.contains("debug")) {
                Bukkit.getLogger().info("[AsyncLoginGate][DEBUG] Called Final Perm set");
            }
            event.allow();
            if (this.luckPermsEnabled && this.permissionAssigner != null) {
                int finalTier = tier;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (parameters.contains("debug")) {
                        Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Assigning permissions to %s UUID: %s tier: %d", playerName, uuid, finalTier));
                    }
                    this.permissionAssigner.assignPermissions(playerName, uuid, parameters, finalTier);
                });
            }
        }
    }

    private Server getServer() {
        return Bukkit.getServer();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        boolean shouldKick;
        String parameters;
        UUID uuid = event.getPlayer().getUniqueId();
        String playerName = event.getPlayer().getName();
        String parametersRaw = this.getConfig().getString("parameters", "");
        String string = parameters = parametersRaw == null ? "" : parametersRaw.toLowerCase();
        if (parameters.contains("debug")) {
            Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] PlayerJoin event for %s UUID: %s", playerName, uuid));
        }
        if (!(shouldKick = this.toKick.contains(uuid))) {
            for (UUID kickUuid : this.toKick) {
                Player kickPlayer = Bukkit.getPlayer((UUID)kickUuid);
                if (kickPlayer == null || !kickPlayer.getName().equalsIgnoreCase(playerName)) continue;
                shouldKick = true;
                uuid = kickUuid;
                if (!parameters.contains("debug")) break;
                Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Found player by name in toKick: %s UUID: %s", playerName, uuid));
                break;
            }
        }
        if (shouldKick) {
            String failMessageRaw;
            if (parameters.contains("debug")) {
                Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Kicking post-login: %s UUID: %s", playerName, uuid));
            }
            String failMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)((failMessageRaw = this.getConfig().getString("fail_message", "You are not authorized to join this server.")) == null ? "You are not authorized to join this server." : failMessageRaw));
            event.getPlayer().kickPlayer(failMessage);
            this.toKick.remove(uuid);
            if (parameters.contains("debug")) {
                Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Removed %s from toKick set after kick", uuid));
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        String parameters;
        UUID uuid = event.getPlayer().getUniqueId();
        String parametersRaw = this.getConfig().getString("parameters", "");
        String string = parameters = parametersRaw == null ? "" : parametersRaw.toLowerCase();
        if (this.toKick.remove(uuid) && parameters.contains("debug")) {
            Bukkit.getLogger().info(String.format("[AsyncLoginGate][DEBUG] Removed %s from toKick set on disconnect", uuid));
        }
    }
}

