/*
 * Decompiled with CFR 0.152.
 */
package com.mcsync.plugin;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class chatToDiscord
implements Listener {
    private final Plugin plugin;

    public chatToDiscord(Plugin plugin) {
        this.plugin = plugin;
    }

    private String getWebhookUrl() {
        return this.plugin.getConfig().getString("discordWebhookURL", "");
    }

    private boolean isDebugEnabled() {
        return this.plugin.getConfig().getString("parameters", "").toLowerCase().contains("debug");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String playerName = event.getPlayer().getName();
        String message = event.getMessage();
        if (this.isDebugEnabled()) {
            this.plugin.getLogger().info("Player " + playerName + " sent message: " + message);
        }
        String formattedMessage = playerName + ": " + message;
        String jsonPayload = String.format("{\"content\": \"%s\"}", formattedMessage);
        if (this.isDebugEnabled()) {
            this.plugin.getLogger().info("Payload created: " + jsonPayload);
        }
        this.sendToDiscord(jsonPayload);
    }

    private void sendToDiscord(String jsonPayload) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            if (this.isDebugEnabled()) {
                this.plugin.getLogger().info("Attempting to send payload to Discord webhook...");
            }
            try {
                int responseCode;
                String webhookUrl = this.getWebhookUrl();
                if (webhookUrl.isEmpty()) {
                    this.plugin.getLogger().severe("Discord webhook URL is not configured!");
                    return;
                }
                URL url = new URL(webhookUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                try (OutputStream outputStream = connection.getOutputStream();){
                    outputStream.write(jsonPayload.getBytes());
                    outputStream.flush();
                }
                if (this.isDebugEnabled()) {
                    this.plugin.getLogger().info("Payload sent. Waiting for response...");
                }
                if ((responseCode = connection.getResponseCode()) == 204) {
                    if (this.isDebugEnabled()) {
                        this.plugin.getLogger().info("Message successfully sent to Discord.");
                    }
                } else {
                    this.plugin.getLogger().warning("Failed to send message to Discord. Response code: " + responseCode);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error while sending message to Discord: " + e.getMessage());
            }
        });
    }
}

